#Quick and Dirty resize to closest base16 and save along with txt file with dimensions
# python.exe Sub10_ResizeToNearest16.py InputImage.jpg --output 'bin\\Temp\\00000.png' --txt 'bin\\Temp\\info.txt' --base 16 --keep-aspect

import argparse
from pathlib import Path
from PIL import Image

parser = argparse.ArgumentParser(
    description="Resize an image to the nearest multiple of N (default 16) and save dimensions to a text file."
)
parser.add_argument("input", help="Path to the input image file")
parser.add_argument("-o", "--output", help="Path to save the resized PNG file", default="resized.png")
parser.add_argument("-t", "--txt", help="Path to save the dimensions text file", default="dimensions.txt")
parser.add_argument("-b", "--base", type=int, default=16, help="Base multiple to resize to (default: 16)")
parser.add_argument("--keep-aspect", action="store_true", help="Preserve aspect ratio when resizing")
args = parser.parse_args()

img = Image.open(args.input)
w, h = img.size
base = args.base

# Compute new dimensions
if args.keep_aspect:
    scale = min(round(w / base) * base / w, round(h / base) * base / h)
    new_w, new_h = int(w * scale), int(h * scale)
else:
    new_w, new_h = round(w / base) * base, round(h / base) * base

# Resize
img = img.resize((new_w, new_h))
img.save(args.output)

# Save dimensions
with open(args.txt, "w") as f:
    f.write(f"Original: {w}x{h}, Resized: {new_w}x{new_h}, Base: {base}, Keep aspect: {args.keep_aspect}\n")
    f.write(f"{new_w}\n")
    f.write(f"{new_h}\n")
    f.write(f"Original: {w}x{h}\n")
    f.write(f"Resized: {new_w}x{new_h}\n")
    f.write(f"Base: {base}\n")
    f.write(f"Keep aspect: {args.keep_aspect}\n")

print(f" Resized image saved as: {args.output}")
print(f" Dimensions saved to: {args.txt}")